<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Courses_controller extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Courses_model'
        ));
        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function courses_view()
    {
        $this->permission->method('courses', 'read')->redirect();

        $data['title'] = display('courses');;
        $data['mang'] = $this->Courses_model->courses_view();
        $data['module'] = "courses";
        $data['page'] = "courses_view";
        echo Modules::run('template/layout', $data);
    }

    public function create_courses()
    {
        $this->form_validation->set_rules('courses_name', 'Course Name');
        $this->form_validation->set_rules('cr_description', 'Description');
        $this->form_validation->set_rules('date', display('date'), 'max_length[50]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');


        #-------------------------------#
        if ($this->form_validation->run() === true) {


            $postData = [
                'courses_name' => $this->input->post('courses_name', true),
                'cr_description' => $this->input->post('cr_description', true),
                'date' => $this->input->post('date', true),
                'employee_id' => $this->input->post('employee_id', true),

            ];

            if ($this->Courses_model->courses_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("courses/Courses_controller/create_courses");


        } else {
            $data['title'] = display('courses');
            $data['module'] = "courses";
            $data['mang'] = $this->Courses_model->courses_view();
            $data['dropdown'] = $this->Courses_model->dropdown();
            $data['page'] = "courses_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function update_courses_form($id = null)
    {
        $data['title'] = display('courses');
        #-------------------------------#
        $this->form_validation->set_rules('courses_id', 'Course ID');
        $this->form_validation->set_rules('courses_name', 'Course Name');
        $this->form_validation->set_rules('cr_description', 'Description');
        $this->form_validation->set_rules('date', display('date'), 'max_length[50]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $Data = [
                'courses_id' => $this->input->post('courses_id', true),
                'courses_name' => $this->input->post('courses_name', true),
                'cr_description' => $this->input->post('cr_description', true),
                'date' => $this->input->post('date', true),
                'employee_id' => $this->input->post('employee_id', true),


            ];

            if ($this->Courses_model->update_courses($Data)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("courses/Courses_controller/courses_view");


        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Courses_model->courses_updateForm($id);
            $data['dropdown'] = $this->Courses_model->dropdown();
            $data['bb'] = $this->Courses_model->get_id($id);
            $data['module'] = "courses";
            $data['page'] = "update_courses_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function delete_courses($id = null)
    {
        $this->permission->method('courses','delete')->redirect();

        if ($this->Courses_model->courses_delete($id)) {
            #set success message
            $this->session->set_flashdata('message',display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception',display('please_try_again'));

        }
        redirect("courses/Courses_controller/courses_view");
    }

}
