<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Courses_model extends CI_Model {
 
    public function courses_view()
	{
        return $this->db->select('count(DISTINCT(cr.courses_id)) as courses_id,cr.*,p.employee_id,p.first_name,p.last_name')
            ->from('courses cr')
            ->join('employee_history p', 'cr.employee_id = p.employee_id', 'left')
            ->group_by('cr.courses_id')
            ->order_by('cr.courses_id', 'desc')
            ->get()
            ->result();
	}
    public function dropdown(){
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where('employee_status',1);
        $query=$this->db->get();
        $data=$query->result();
        $list = array('' => 'Select One...');
        if(!empty($data)){
            foreach ($data as  $value) {
                $list[$value->employee_id]=$value->first_name." ".$value->last_name;
            }
        }
        return $list;
    }
    public function courses_create($data = array())
    {
        return $this->db->insert('courses', $data);
    }

    public function update_courses($data = array())
    {
        return $this->db->where('courses_id',$data["courses_id"])
            ->update("courses", $data);
    }
    public function courses_updateForm($id){
        $this->db->where('courses_id',$id);
        $query = $this->db->get('courses');
        return $query->row();
    }
    public  function get_id($id)
    {
        $query=$this->db->get_where('courses',array('courses_id'=>$id));
        return $query->row_array();
    }

    public function courses_delete($id = null)
    {
        $this->db->where('courses_id',$id)
            ->delete('courses');

        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }

}
