<?php
$current_date = date("Y-m-d");
$current_time = strtotime($current_date);

?>
<div class="row">
    <div class="col-sm-12 col-md-12">

        <div class="panel panel-bd">

            <div class="panel-heading">
                <div class="panel-title">
                    <h4><?php echo "Filter" ?></h4>
                </div>
            </div>

            <div class="panel-body">
                <?php echo form_open('employee/Employees/employee_filter', array('class' => 'form-inline', 'method' => 'post')) ?>

                <div style="display: inline-flex;" class="form-group form-group-new">
                    <label for="employee_status"><?php echo "By Employee Status" ?> :</label>
                    <select name="employee_status" class="form-control">
                        <option value="">Select Status</option>
                        <option value="4">Cancelled
                        </option>
                        <option value="3">Not Started
                        </option>
                        <option value="2">On Leave
                        </option>
                        <option value="1">Active
                        </option>
                        <option value="5">Inactive
                        </option>
                    </select>
                </div>

                <div style="display: inline-flex;" class="form-group form-group-new">
                    <label for="employee_job_status"><?php echo "By Employee Job Status" ?> :</label>
                    <select name="employee_job_status" class="form-control">
                        <option value="">Select Status</option>
                        <option value="2">Permanent
                        </option>
                        <option value="1">Extended Probation
                        </option>
                        <option value="3">Probation
                        </option>

                    </select>
                </div>
                <div style="display: inline-flex;" class="form-group form-group-new">
                    <label for="duty_type"><?php echo "Duty Type" ?> :</label>
                    <select name="duty_type" class="form-control">
                        <option value="">Select Status</option>
                        <option value="1">Intern
                        </option>
                        <option value="2">Full Time
                        </option>
                        <option value="3">Part Time
                        </option>
                        <option value="4">Contructual
                        </option>
                        <option value="5">Other
                        </option>

                    </select>
                </div>

                <button style="margin-bottom: 10px;" type="submit" class="btn btn-success"><?php echo display('search') ?></button>

                <?php echo form_close() ?>
            </div>


        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">

        <div class="panel-title bulk_add_emp_btn float-right">
            <button type="button" class="btn btn-success btn-md" data-toggle="modal" data-target="#myModal">Add Bulk
                Employees
            </button>
            <a href="<?php echo base_url(); ?>/employee/Employees/excel" class="btn btn-primary">Export to CSV</a>
        </div>

        <div class="Alert hide">
            <span class="fa fa-check-circle"></span>
            <span class="msg">Updated Successfully</span>
            <div class="close-btn">
                <span class="fa fa-times"></span>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="myModal" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">Add Employees</h4>
                    </div>
                    <div class="modal-body">
                        <?php echo form_open_multipart('employee/Employees/bulk_import_csv', array('class' => 'form-vertical', 'id' => 'validate', 'name' => 'insert_employee')) ?>
                        <input type="file" name="upload_csv_file" id="empfile" required><br><br>
                        <p><a href="<?php echo base_url('assets/files/employees.csv') ?>">Click here to download the
                                sample file</a></p>
                        <p><b>Note:</b> <span class="text-danger">Employee file data format must be as given sample file.</span>
                        </p><br>
                        <input type="submit" name="submit" value="UPLOAD" class="btn btn-success">
                        <?php echo form_close() ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<div class="row employee_listing">
    <!--  table area -->
    <div class="col-sm-12">

        <div id="ajax_response"></div>

        <div class="panel panel-bd">

            <div class="panel-body table-responsive">
                <table width="100%" class="datatable table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th><?php echo display('employee_id') ?></th>
                        <th><?php echo display('first_name') ?></th>
                        <th><?php echo display('last_name') ?></th>
                        <th><?php echo display('position') ?></th>
                        <th><?php echo "Status" ?></th>
                        <th><?php echo display('action') ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if (!empty($emp_history)) { ?>
                        <?php $sl = 1; ?>
                        <?php foreach ($emp_history as $row) {

                            $probation_date = $row->original_hire_date;
                            $probation_time = strtotime($probation_date);

                            if ($row->warning == 0 || $row->warning == null) {
                                $warning = 0;
                            } else {
                                $warning = $row->warning;
                            }
                            ?>
                            <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                <td><?php echo $row->employee_id; ?></td>
                                <td><?php echo $row->first_name; ?></td>
                                <td><?php echo $row->last_name; ?></td>
                                <td><?php echo $row->position_name; ?></td>
                                <td class="emp_status_option">
                                    <select onchange="change_employee_status(this, <?php echo $row->employee_id ?>)"
                                            class="form-control" name="employee_status" id="employee_status_quick">
                                        <option value="">Select Status</option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "4" ? 'selected' : '' : '' ?>
                                                value="4">Cancelled
                                        </option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "3" ? 'selected' : '' : '' ?>
                                                value="3">Not Started
                                        </option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "2" ? 'selected' : '' : '' ?>
                                                value="2">On Leave
                                        </option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "1" ? 'selected' : '' : '' ?>
                                                value="1">Active
                                        </option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "0" ? 'selected' : '' : '' ?>
                                                value="0">Inactive
                                        </option>
                                    </select>
                                </td>
                                <td class="center">
                                    <?php if ($this->permission->method('employee', 'update')->access()): ?>
                                        <a href="<?php echo base_url("employee/Employees/update_employee_form/$row->employee_id") ?>"
                                           class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>
                                    <?php endif; ?>
                                    <?php if ($this->permission->method('employee', 'delete')->access()): ?>
                                        <a href="<?php echo base_url("employee/Employees/delete_employhistory/$row->employee_id") ?>"
                                           class="btn btn-xs btn-danger"
                                           onclick="return confirm('<?php echo display('are_you_sure') ?>') "><i
                                                    class="fa fa-trash"></i></a>
                                    <?php endif; ?>
                                    <a href="<?php echo base_url("employee/Employees/cv/$row->employee_id"); ?>"
                                       class="btn btn-default btn-xs"><i class="fa fa-user"></i></a>

                                    <?php
                                    if ($row->terminate == 1) { ?>
                                        <em style="color: red">Terminated</em>
                                    <?php } else { ?>
                                        <!-- Confirmation and termination -->
                                        <select name="" id="" class="my-select"
                                                onchange="myFunction(<?php echo $row->employee_id ?>,<?php echo $row->rate ?>,<?php echo $warning ?>,<?php echo $row->pos_id ?>,'<?php echo $row->position_name ?>',this,'<?php echo $row->first_name ?>' , '<?php echo $row->last_name ?>' , '<?php echo $row->email ?>' )">
                                            <option value="0" selected disabled hidden>Choose here</option>
                                            <?php
                                            if ($probation_time > $current_time) { ?>
                                                <option value="1">Confirmation</option>
                                            <?php }
                                            ?>
                                            <option value="2">Warning</option>
                                            <option value="3">Terminate</option>
                                        </select>
                                    <?php }
                                    ?>


                                </td>
                            </tr>
                            <?php $sl++; ?>
                        <?php } ?>
                    <?php } ?>
                    </tbody>
                </table>  <!-- /.table-responsive -->
            </div>
        </div>
    </div>
</div>

<!-- ConfirmationModal Start -->
<div id="ConfirmationModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i> Confirmation </h4></strong>
                </center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/update_salary_position') ?>

                                <div class="form-group row">
                                    <!--                                    Hidden Fields-->
                                    <input type="hidden" id="hidden_id_model_conformation"
                                           name="hidden_id_model_conformation" class="form-control">
                                    <input type="hidden" id="fname_modal_sal" name="fname_modal_sal"
                                           class="form-control">
                                    <input type="hidden" id="lname_modal_sal" name="lname_modal_sal"
                                           class="form-control">
                                    <input type="hidden" id="email_modal_sal" name="email_modal_sal"
                                           class="form-control">
                                    <input type="hidden" id="position_modal_sal" name="position_modal_sal"
                                           class="form-control">
                                    <input type="hidden" id="current_salary" name="current_salary"
                                           class="form-control">

                                    <label for="certificate_name" class="col-sm-3 col-form-label">
                                        <?php echo "Update Salary" ?></label>
                                    <div class="col-sm-9">
                                        <input type="number" id="salary" name="salary"
                                               placeholder="<?php echo "Update Salary" ?>" class=" form-control">
                                    </div>
                                </div>
                                <div class="form-group row">

                                    <label for="employee_id" class="col-sm-3 col-form-label">
                                        <?php echo "Position update"; ?></label>
                                    <div class="col-sm-9">
                                        <!--                                        --><?php //echo form_dropdown('employee_id',$dropdown,null,'class="form-control codeigniterselect"') ?>
                                        <select name="designation" id="designation" class="form-control">
                                            <option value="">select Designation</option>
                                            <!--                                            <option value=""  disabled selected hidden> </option>-->
                                            <?php foreach ($designation as $desig) { ?>
                                                <option value="<?php echo $desig->pos_id ?>"><?php echo $desig->position_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="ct_description" class="col-sm-3 col-form-label">
                                        <?php echo "Comment" ?></label>
                                    <div class="col-sm-9">
                                        <textarea name="comment" placeholder="<?php echo "Enter Comment" ?>"
                                                  class=" form-control"></textarea>

                                    </div>

                                </div>
                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>

</div>
<!--ConfirmationModal END-->

<!--TerminationModal Start-->
<div id="TerminationModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i> Warning </h4></strong>
                </center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/update_warning') ?>

                                <div class="form-group row" id="ter_div_1">
                                    <input type="hidden" id="hidden_id_model_termination"
                                           name="hidden_id_model_termination" class="form-control">
                                    <input type="hidden" id="hidden_warning_no_model" name="hidden_warning_no_model"
                                           class="form-control">
                                    <input type="hidden" id="fname_modal_ter" name="fname_modal_ter"
                                           class="form-control">
                                    <input type="hidden" id="lname_modal_ter" name="lname_modal_ter"
                                           class="form-control">
                                    <input type="hidden" id="email_modal_ter" name="email_modal_ter"
                                           class="form-control">
                                    <input type="hidden" id="position_modal_ter" name="position_modal_ter"
                                           class="form-control">

                                </div>

                                <div class="form-group row" id="ter_div_2">

                                    <label for="ct_description" class="col-sm-3 col-form-label">
                                        <?php echo "Reason" ?></label>
                                    <div class="col-sm-9">
                                        <textarea name="reason" placeholder="<?php echo "Enter Reason" ?>"
                                                  class=" form-control" required></textarea>

                                    </div>

                                </div>
                                <div class="form-group form-group-margin text-right" id="ter_div_3">
                                    <!--                                    <button type="reset" class="btn btn-primary w-md m-b-5">-->
                                    <?php //echo display('reset') ?><!--</button>-->
                                    <button type="submit" id="btn_save_termination"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>

                                <?php echo form_close() ?>

                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>

</div>
<!--TerminationModal End-->

<!--Terminate Modal Start-->
<div id="terminateModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i> Terminate </h4></strong>
                </center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/terminate') ?>

                                <div class="form-group row">
                                    <input type="hidden" id="ter_emp_id"
                                           name="ter_emp_id" class="form-control">
                                    <input type="hidden" id="ter_first_name" name="ter_first_name"
                                           class="form-control">
                                    <input type="hidden" id="ter_last_name" name="ter_last_name"
                                           class="form-control">
                                    <input type="hidden" id="ter_email" name="ter_email"
                                           class="form-control">

                                </div>

                                <div class="form-group row" id="ter_div_2">

                                    <label for="ter_description" class="col-sm-3 col-form-label">
                                        <?php echo "Reason" ?></label>
                                    <div class="col-sm-9">
                                        <textarea name="ter_reason" placeholder="<?php echo "Enter Reason" ?>"
                                                  class=" form-control" required></textarea>

                                    </div>

                                </div>
                                <div class="form-group form-group-margin text-right" id="ter_div_3">
                                    <!--                                    <button type="reset" class="btn btn-primary w-md m-b-5">-->
                                    <?php //echo display('reset') ?><!--</button>-->
                                    <button type="submit" id="btn_save_terminate"
                                            onclick="return confirm('Are you sure to terminate this employee? You cannot edit once termination email has been sent.')"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>

                                <?php echo form_close() ?>

                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>

</div>
<!--Terminate Modal End-->

<script src="<?php echo MOD_URL . 'employee/assets/js/script.js'; ?>" type="text/javascript"></script>
