<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Attendance_model extends CI_Model
{

    public function check_in($data = array())
    {
        $this->db->insert('employee_attendance', $data);
        return true;
    }

    public function check_out($data = array())
    {
        return $this->db->where('att_id', $data["att_id"])
            ->update("employee_attendance", $data);

    }

    public function check_flag($id)
    {

        return $this->db->select('*')
            ->from('employee_attendance')
            ->where('employee_id', $id)
            ->order_by('att_id', 'desc')
            ->limit(1)
            ->get()
            ->result();
    }

    public function get_all_attendance()
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name,b.shift_start')
            ->from('employee_attendance a')
            ->join('employee_history b', 'a.employee_id=b.employee_id', 'left')
            ->order_by('a.att_id', 'desc')
            ->get()
            ->result();
        return $result;
    }

    public function get_filter_attendance($employee_id, $start_date, $end_date)
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name')
            ->from('employee_attendance a')
            ->join('employee_history b', 'a.employee_id=b.employee_id', 'left')
            ->where('a.employee_id', $employee_id)
            ->where('a.check_in_date >=', $start_date)
            ->where('a.check_in_date <=', $end_date)
            ->order_by('a.att_id', 'desc')
            ->get()
            ->result();
        return $result;
    }

    public function get_employee_attendance($id)
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name')
            ->from('employee_attendance a')
            ->where('a.employee_id', $id)
            ->join('employee_history b', 'a.employee_id=b.employee_id', 'left')
            ->order_by('a.att_id', 'desc')
            ->get()
            ->result();
        return $result;
    }

    public function get_team_attendance($id)
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name')
            ->from('employee_attendance a')
            ->join('employee_history b', 'a.employee_id=b.employee_id', 'left')
            ->where('b.super_visor_id', $id)
            ->order_by('a.att_id', 'desc')
            ->get()
            ->result();
        return $result;
    }

    public function get_filter_employee_attendance($id, $start_date, $end_date)
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name')
            ->from('employee_attendance a')
            ->where('a.employee_id', $id)
            ->where('check_in_date >=', $start_date)
            ->where('check_in_date <=', $end_date)
            ->join('employee_history b', 'a.employee_id=b.employee_id', 'left')
            ->order_by('a.att_id', 'desc')
            ->get()
            ->result();
        return $result;
    }

    public function get_attendance_record($id)
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name')
            ->from('employee_attendance a')
            ->where('a.att_id', $id)
            ->join('employee_history b', 'a.employee_id=b.employee_id', 'left')
            ->get()
            ->result();
        return $result;
    }

    public function check_in_update($data = array())
    {
        return $this->db->where('att_id', $data["att_id"])
            ->update("employee_attendance", $data);
    }

    public function get_current_record($id)
    {
        return $this->db->select('*')
            ->from('employee_attendance')
            ->where('att_id', $id)
            ->get()
            ->result();
    }

    public function check_out_update($data = array())
    {
        return $this->db->where('att_id', $data["att_id"])
            ->update("employee_attendance", $data);
    }

    public function get_overtime_details($id)
    {
        $this->db->select("*");
        $this->db->from('employee_overtime');
        $this->db->where('employee_id', $id);
        $this->db->where('approve_by_sup', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_team_overtime_details($id)
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name')
            ->from('employee_overtime a')
            ->join('employee_history b', 'a.employee_id=b.employee_id', 'left')
            ->where('b.super_visor_id', $id)
            ->where('a.approve_by_sup', 1)
            ->order_by('a.ovt_id', 'desc')
            ->get()
            ->result();
        return $result;
    }

    public function get_filter_overtime_details($id, $start_date, $end_date)
    {
        $this->db->select("*");
        $this->db->from('employee_overtime');
        $this->db->where('employee_id', $id);
        $this->db->where('approve_by_sup', 1);
        $this->db->where('ovt_start_date >=', $start_date);
        $this->db->where('ovt_start_date <=', $end_date);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_admin_overtime()
    {
        $this->db->select('employee_overtime.* ,employee_history.*');
        $this->db->join('employee_history', 'employee_history.employee_id = employee_overtime.employee_id');
        $this->db->where('approve_by_sup', 1);
        $this->db->from('employee_overtime');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_filter_admin_overtime($employee_id, $start_date, $end_date)
    {
        $this->db->select('employee_overtime.* ,employee_history.*');
        $this->db->join('employee_history', 'employee_history.employee_id = employee_overtime.employee_id');
        $this->db->from('employee_overtime');
        $this->db->where('approve_by_sup', 1);
        $this->db->where('employee_overtime.employee_id', $employee_id);
        $this->db->where('ovt_start_date >=', $start_date);
        $this->db->where('ovt_start_date <=', $end_date);
        $query = $this->db->get();
        return $query->result();
    }

    public function emp_list_dropdown()
    {
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where('employee_status', 1);
        $query = $this->db->get();
        $data = $query->result();

        if (!empty($data)) {
            return $data;
        } else {
            return false;
        }
    }

    public function emp_team_list_dropdown($id)
    {
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where('super_visor_id', $id);
        $query = $this->db->get();
        $data = $query->result();

        if (!empty($data)) {
            return $data;
        } else {
            return false;
        }
    }

    public function attendance_import($em_code)
    {
        $this->db->select('employee_id');
        $this->db->where('emp_code',$em_code);
        $q = $this->db->get('employee_history');
        $data = $q->result_array();
        return $data[0]['employee_id'];
    }

    public function attendance_insert($post){
        return $this->db->insert('employee_attendance', $post);
    }

    public function attendance_date($em_id, $check_in_date)
    {
        $this->db->select('check_in_date');
        $this->db->where('employee_id', $em_id);
        $this->db->where('check_in_date', $check_in_date);
        $q = $this->db->get('employee_attendance');
        $data = $q->result_array();
        // print_r($data);
        return $data[0]['check_in_date'];
    }
    public function attendance_id($em_id)
    {
        $this->db->select('employee_id');
        $this->db->where('employee_id', $em_id);
        $q = $this->db->get('employee_attendance');
        $data = $q->result_array();
        return $data[0]['employee_id'];
    }

    public function attendance_update($data = array())
    {
        return $this->db->where('employee_id', $data["employee_id"])
            ->where('check_in_date', $data["check_in_date"])
            ->update("employee_attendance", $data);
    }

    public function get_late($d){
        $this->db->select('late');
        $this->db->where('employee_id', $d);
        $q = $this->db->get('employee_attendance');
        $data = $q->result_array();
        return $data[0]['late'];

    }
    public function in_update($data){
        return $this->db->where('employee_id', $data["employee_id"])
            ->where('check_in_date', $data["check_in_date"])
            ->update("employee_attendance", $data);

    }
}
