<?php
$ip = $_SERVER['REMOTE_ADDR'];
$ipInfo = file_get_contents('http://ip-api.com/json/' . $ip);
$ipInfo = json_decode($ipInfo);
$timezone = $ipInfo->timezone;
date_default_timezone_set($timezone);
$current_datetime = date('Y-m-d H:i:s');
$current_date = date('Y-m-d', strtotime("$current_datetime"));
$current_time = date('H:i:s', strtotime("$current_datetime"));
?>
<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="panel panel-bd">

            <div class="panel-heading">
                <div class="panel-title">
                    <h4><?php echo "Filter" ?></h4>
                </div>
            </div>

            <div class="panel-body">
                <?php echo form_open('employeeattendance/Attendance/team_attendance', array('class' => 'form-inline', 'method' => 'post')) ?>

                <div style="display: inline-flex;" class="form-group form-group-new">
                    <label for="employee_id"><?php echo "Select Employee" ?> :</label>
                    <select name="employee_id" class="form-control">
                        <option value="">Select One</option>
                        <?php foreach ($emplist as $emp) { ?>
                            <option value="<?php echo $emp->employee_id ?>"><?php echo $emp->first_name . ' ' . $emp->last_name ?></option>
                        <?php } ?>
                    </select>
                </div>

                <div class="form-group form-group-new">
                    <label for="start_date"><?php echo display('start_date') ?> :</label>
                    <input type="text" name="start_date" value="<?php echo date('Y-m-d') ?>"
                           class="datepicker form-control"/>
                </div>
                <div class="form-group form-group-new">
                    <label for="end_date"><?php echo display('end_date') ?> :</label>
                    <input type="text" class="datepicker form-control" name="end_date"
                           value="<?php echo date('Y-m-d') ?>"/>
                </div>
                <button type="submit" class="btn btn-success"><?php echo display('search') ?></button>

                <?php echo form_close() ?>
            </div>


        </div>
    </div>
</div>

<div class="row">
    <!--  table area -->
    <div class="col-sm-12">

        <div class="panel panel-bd">

            <div class="panel-heading">
                <div class="panel-title">
                    <h4>
                        <?php echo "Attendance Log" ?>
                    </h4>
                </div>
            </div>

            <div class="panel-body">
                <table width="100%" class="datatable table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th><?php echo display('cid') ?></th>
                        <th><?php echo "Employee Name" ?></th>
                        <th><?php echo "Check in Date" ?></th>
                        <th><?php echo "Check in Time" ?></th>
                        <th><?php echo "Check out Date" ?></th>
                        <th><?php echo "Check out Time" ?></th>
                        <th><?php echo "Total Hours (HH:MM)" ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if (!empty($mang)) { ?>
                        <?php $sl = 1; ?>
                        <?php foreach ($mang as $row) {
                            $check_out_datetime = date('Y-m-d H:i:s', strtotime("$row->check_out_date $row->check_out_time"));
                            $total_time = $row->total_hours;
                            $hour = floor($total_time);
                            $minute = round(($total_time - $hour) * 60);
                            ?>
                            <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                <td><?php echo $sl; ?></td>
                                <td><?php echo $row->first_name . " " . $row->last_name; ?></td>
                                <td><?php echo $row->check_in_date; ?></td>
                                <td><?php echo $row->check_in_time; ?></td>
                                <?php
                                if ($current_datetime < $check_out_datetime) {
                                    $check_out_date = '';
                                } else {
                                    $check_out_date = $row->check_out_date;
                                }
                                ?>
                                <td><?php echo $check_out_date; ?></td>
                                <?php
                                if ($current_datetime < $check_out_datetime) {
                                    $check_out_time = '';
                                } else {
                                    $check_out_time = $row->check_out_time;
                                }
                                ?>
                                <td><?php echo $check_out_time; ?></td>
                                <?php
                                if ($current_datetime < $check_out_datetime) {
                                    $hours = '';
                                    $minutes = '';
                                } else {
                                    $hours = $hour;
                                    $minutes = $minute;
                                }
                                ?>
                                <td><?php echo $hours . ':' . $minutes; ?></td>
                            </tr>
                            <?php $sl++; ?>
                        <?php } ?>
                    <?php } ?>
                    </tbody>
                </table>  <!-- /.table-responsive -->
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="panel panel-bd lobidrag">
            <div class="panel-heading">
                <div class="panel-title">
                    <h4><?php echo "Overtime Logs" ?></h4>
                </div>
            </div>
            <div class="panel-body">
                <table width="100%" class="datatable table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th><?php echo 'Name' ?></th>
                        <th><?php echo 'Start Date' ?></th>
                        <th><?php echo 'Start Time' ?></th>
                        <th><?php echo 'End Date' ?></th>
                        <th><?php echo 'End Time' ?></th>
                        <th><?php echo 'Reason' ?></th>
                        <th><?php echo 'Total Time (HH:MM)' ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if (!empty($ovt_details)) { ?>
                        <?php $sl = 1; ?>
                        <?php foreach ($ovt_details as $row) {
                            if ($row->approve_by_sup == 1) {
                                $approval = 'Approved';
                            } else if ($row->approve_by_sup == 0) {
                                $approval = 'Rejected';
                            } else {
                                $approval = 'Pending';
                            }

                            $total_time = $row->total_time;
                            $hour = floor($total_time);
                            $minute = round(($total_time - $hour) * 60);
                            ?>
                            <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                <td class="center">
                                    <p><?php echo $row->first_name . " " . $row->last_name ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_start_date ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_start_time ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_end_date ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_end_time ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_reason ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $hour . ":" . $minute ?></p>
                                </td>
                            </tr>
                            <?php $sl++; ?>
                        <?php } ?>
                    <?php } ?>
                    </tbody>
                </table>  <!-- /.table-responsive -->

                <?php
                if (!empty($mang)) {
                    $total_att_time = '';
                    foreach ($mang as $row) {
                        $total_time = $row->total_hours;
                        $total_att_time += $total_time;
                    }
                }
                if (!empty($ovt_details)) {
                    $total_ovt_time = '';
                    foreach ($ovt_details as $row) {
                        $totalTime = $row->total_time;
                        $total_ovt_time += $totalTime;
                    }
                }

                $time = $total_att_time + $total_ovt_time;
                $hour = floor($time);
                $minute = round(($time - $hour) * 60);
                ?>
                <?php
                if ($filter_enable == 1) { ?>
                    <p class="text-center" style="margin-bottom: 20px;">Total time for this employee is
                        <b><?php echo $hour ?> Hours</b>
                        and
                        <b><?php echo $minute ?> minutes</b> Including Overtime</p>
                <?php }
                ?>


            </div>
        </div>
    </div>
</div>
