<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Query extends MX_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Query_model'
        ));
        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function create_query(){

        $email = $this->session->userdata('email');
        $data['employ_data'] = $this->Query_model->get_employ_detail($email);
        $sup_id = $data['employ_data'][0]->super_visor_id;
        $sup_email = $this->Query_model->get_sup_email($sup_id);
        $sup_email = $sup_email[0]->email;
        $emp_name = $data['employ_data'][0]->first_name.' '.$data['employ_data'][0]->last_name;


        $this->form_validation->set_rules('your_query', display('message'), 'required|trim');
        /*-------------STORE DATA------------*/
        $this->load->library('myupload');
        $attachment = $this->myupload->do_upload(
            './application/modules/employeequery/assets/attachment/',
            'qury_attachment'
        );
        if ($attachment == null) {
            $res_attachment = '';
        } else {
            $res_attachment = base_url() . $attachment;
        }
            $data['message'] = (object)$postData = array(
            'your_query' => $this->input->post('your_query', true),
            'query_attachment' => $res_attachment,
            'employee_id' => $this->input->post('employee_id', true),
            'title' => $this->input->post('title', true),
            'query_date' => date('Y-m-d'),

            );
        if ($this->form_validation->run() === true) {
            if ($this->Query_model->create_query($postData)) {
                #set success message

                $this->load->library('email');
                $this->email->set_mailtype("html");
                $this->email->attach($res_attachment);

//                Email to employee
                $this->email->from(FROM_EMAIL); // change it to yours
                $this->email->to($email); // change it to yours
                $this->email->subject("Your Query Send");
                $this->email->message("<h1> Your Query has been sent to your supervisor </h1>");
                if ($this->email->send()) {
                } else {
                    show_error($this->email->print_debugger());
                }
//                Email To Supervisor
                $this->email->from(FROM_EMAIL); // change it to yours
                $this->email->to($sup_email); // change it to yours
//                $this->email->to('inam.ur.rehman@dynatuners.com'); // change it to yours
                $this->email->subject("New Query Generated");
                $this->email->message("<h1> $emp_name Create A Query </h1>");
                if ($this->email->send()) {
                } else {
                    show_error($this->email->print_debugger());
                }
//                $this->session->set_flashdata('message', "Your Query has been sent to your supervisor");
                $this->session->set_flashdata('message', display('successfully_updated')); // sucess Message
            } else {
                #set exception message
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('employeequery/Query/create_query');
        }else {
            $data['title'] = "Employee Query";
            $email = $this->session->userdata('email');
            $data['employ_data'] = $this->Query_model->get_employ_detail($email);
            $data['page'] = "create_query";
            $data['module'] = 'employeequery';
            echo Modules::run('template/layout', $data);
        }
    }

    public function query_request(){
        $data['title'] = "Query Request";
        $email = $this->session->userdata('email');
        $data['employ_data'] = $this->Query_model->get_employ_detail($email);
        $emp_id = $data['employ_data'][0]->employee_id;
        if($emp_id != null || $emp_id != "" ){
            $data['quries_self'] = $this->Query_model->get_query_detail_self($emp_id);
            $data['quries'] = $this->Query_model->get_query_detail($emp_id);
            $data['quries_hr'] = $this->Query_model->get_query_detail_hr($emp_id);
            $data['id_check'] = "1";
            $data['page'] = "query_request";
            $data['module'] = 'employeequery';
            echo Modules::run('template/layout', $data);
        } else {
            $data['id_check'] = "0";
            $data['page'] = "query_request";
            $data['module'] = 'employeequery';
            echo Modules::run('template/layout', $data);
        }
    }
    public function self_query_request(){
        $data['title'] = "Self Queries";
        $email = $this->session->userdata('email');
        $data['employ_data'] = $this->Query_model->get_employ_detail($email);
        $emp_id = $data['employ_data'][0]->employee_id;

        if($emp_id != null || $emp_id != "" ){
            $data['quries_self'] = $this->Query_model->get_query_detail_self($emp_id);
            $data['module'] = 'employeequery';
            $data['page'] = "self_query";
            echo Modules::run('template/layout', $data);
        } else {
            $data['id_check'] = "0";
            $data['page'] = "query_request";
            $data['module'] = 'employeequery';
            echo Modules::run('template/layout', $data);
        }
    }
    public function team_query_request(){
        $data['title'] = "Team Queries";
        $email = $this->session->userdata('email');
        $data['employ_data'] = $this->Query_model->get_employ_detail($email);
        $emp_id = $data['employ_data'][0]->employee_id;

        if($emp_id != null || $emp_id != "" ){
            $data['quries'] = $this->Query_model->get_query_detail($emp_id);
            $data['module'] = 'employeequery';
            $data['page'] = "team_query";
            echo Modules::run('template/layout', $data);
        } else {
            $data['id_check'] = "0";
            $data['page'] = "query_request";
            $data['module'] = 'employeequery';
            echo Modules::run('template/layout', $data);
        }
    }
    public function request_by_supervisor(){
        $data['title'] = "Request by Supervisor";
        $email = $this->session->userdata('email');
        $data['employ_data'] = $this->Query_model->get_user_detail($email);
        $emp_id = $data['employ_data'][0]->id;

        if($emp_id != null || $emp_id != "" ){
            $data['quries_hr'] = $this->Query_model->get_query_detail_hr($emp_id);
            $data['module'] = 'employeequery';
            $data['page'] = "request_by_supervisor";
            echo Modules::run('template/layout', $data);
        } else {
            $data['id_check'] = "0";
            $data['module'] = 'employeequery';
            $data['page'] = "request_by_supervisor";
            echo Modules::run('template/layout', $data);
        }
    }
    public function view_query($id = null){
        $data['title'] = "View Query";
        $data['query_data'] = $this->Query_model->get_query($id);
//        print_r($data['query_data']);
//        die();
        $data['module'] = 'employeequery';
        $data['page'] = "view_query";
        echo Modules::run('template/layout', $data);
    }
    public function view_query_employee($id = null){
        $data['title'] = "View Query";

        $email = $this->session->userdata('email');
        $data['employ_data'] = $this->Query_model->get_employ_detail($email);
        $emp_id = $data['employ_data'][0]->employee_id;
        $data['query_data'] = $this->Query_model->get_query($id);

//        echo $data['employ_data'][0]->employee_id;
//        echo "<br>";
//        echo $data['query_data']->employee_id;
        if($data['employ_data'][0]->employee_id != $data['query_data']->employee_id || $data['query_data']->employee_id == "" || $data['query_data']->employee_id == null  ){
            redirect('employeequery/Query/query_request');
//            echo "Pakistan";
        }

        $data['module'] = 'employeequery';
        $data['page'] = "view_query_employee";
        echo Modules::run('template/layout', $data);
    }
    public function edit_query_sup(){
        $this->form_validation->set_rules('sup_comments', display('message'), 'required|trim');
        $this->form_validation->set_rules('approve_by_supervisor', display('message'), 'required|trim');

        $query_id = $this->input->post('query_id', true);
//        $employee_id = $this->input->post('employee_id', true);
        $approve_by_supervisor = $this->input->post('approve_by_supervisor', true);
        $sup_comments = $this->input->post('sup_comments', true);

        $email = $this->session->userdata('email');
        $data['employ_data'] = $this->Query_model->get_employ_detail($email);
        $emp_id = $data['employ_data'][0]->employee_id;
        $title = $this->input->post('title', true);

        $query_create_by = $this->Query_model->get_query_employee_email($query_id);
        if($approve_by_supervisor == 2){

        }

        $data['approval'] = (object)$postData = array(
            'id' => $query_id,
            'approve_by_supervisor' => $approve_by_supervisor,
            'sup_comments' => $sup_comments,
            'supervisor_id' => $emp_id
        );
        if ($this->form_validation->run() === true) {
            if($this->Query_model->update_query_supervisor($postData)){
                $this->session->set_flashdata('message', "Your Request has been sent to HR");
//              EMail code
                $this->load->library('email');
                $this->email->set_mailtype("html");
//                $this->email->attach($res_attachment);

//              Email To HR
                $this->email->from(FROM_EMAIL); // change it to yours
                $this->email->to('human.resource@dynatuners.com'); // change it to yours
                $this->email->subject("Query From Supervisor");
                $this->email->message("<h1> Message for HR </h1>");
                if ($this->email->send()) {
                } else {
                    show_error($this->email->print_debugger());
                }
//              email to Employee
                $this->email->from(FROM_EMAIL);
                $this->email->to($query_create_by[0]->email); // change it to yours
                $this->email->subject(" $title Query Forward");
                $this->email->message("<h1> Message for Employ </h1>");
                if ($this->email->send()) {
                } else {
                    show_error($this->email->print_debugger());
                }
            }else{
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('employeequery/Query/team_query_request');
        }else{
            $this->session->set_flashdata('exception', display('Provide All the Options'));
            redirect('employeequery/Query/view_query');
        }
    }

    public function view_query_hr($id = null){
        $data['title'] = "View Query";
        $data['query_data'] = $this->Query_model->get_query($id);
        $data['page'] = "view_query_hr";
        $data['module'] = 'employeequery';
        echo Modules::run('template/layout', $data);
    }

    public function edit_query_hr(){
        $this->form_validation->set_rules('hr_comments', display('message'), 'required|trim');
        $this->form_validation->set_rules('approve_by_hr', display('message'), 'required|trim');

        $query_id = $this->input->post('query_id', true);
        $hr_comments = $this->input->post('hr_comments', true);
        $approve_by_hr = $this->input->post('approve_by_hr', true);
        $title = $this->input->post('title', true);

        $email = $this->session->userdata('email');
        $data['employ_data'] = $this->Query_model->get_employ_detail($email);
        $emp_id = $data['employ_data'][0]->employee_id;

        $query_create_by = $this->Query_model->get_query_employee_email($query_id);
        $query_supervisor = $this->Query_model->get_query_supervisor_email($query_id);


        $data['approval'] = (object)$postData = array(
            'id' => $query_id,
            'hr_comments' => $hr_comments,
            'approve_by_hr' => $approve_by_hr,
            'hr_id' => $emp_id
        );
        if ($this->form_validation->run() === true) {
            if($this->Query_model->update_query_supervisor($postData)){
                $this->session->set_flashdata('message', "Your Responce has sent Back to Employ");

                //              EMail code
                $this->load->library('email');
                $this->email->set_mailtype("html");
//                $this->email->attach($res_attachment);

//              Email To HR
                $this->email->from(FROM_EMAIL); // change it to yours
                $this->email->to($query_supervisor[0]->email); // change it to yours
                $this->email->subject(" $title Query Update");
                $this->email->message("<h1> Message for Supervisor </h1>");
                if ($this->email->send()) {
                } else {
                    show_error($this->email->print_debugger());
                }
//              email to Employee
                $this->email->from(FROM_EMAIL);
                $this->email->to($query_create_by[0]->email); // change it to yours
                $this->email->subject("$title Query Update");
                $this->email->message("<h1> Message for Employ </h1>");
                if ($this->email->send()) {
                } else {
                    show_error($this->email->print_debugger());
                }

            }else{
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('employeequery/Query/request_by_supervisor');
        }
    }
}