<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Candidate extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Candidate_model'
        ));
        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function candidateinfo_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = display('candidate_list');;
        $data['caninfo'] = $this->Candidate_model->viewcanInfo();
        $data['edu'] = $this->Candidate_model->viewEduinfo();
        $data['exp'] = $this->Candidate_model->viewExperience();
        $data['module'] = "recruitment";
        $data['page'] = "canInfoview";
        echo Modules::run('template/layout', $data);
    }

    public function excel()
    {
        $file_name = 'Candidate_details_on_' . date('Ymd') . '.csv';
        header("Content-Description: File Transfer");
        header("Content-Disposition: attachment; filename=$file_name");
        header("Content-Type: application/csv;");

        // get data
        $Candidate_data = $this->Candidate_model->csvdata();
        $file = fopen('php://output', 'w');

        $header = array("Candidate_id", "Firstname", "Lastname", "Email", "Phone",
            "alternative Phone", "Present Address", "Permanent Address", "Picture",
            "Resume", "SSN", "Candidate_Type", "Position", "State", "City", "Zip",
            "Linkedin_Profile", "Github", "Heard About Job", "English Frequency", "Status"
        );
        fputcsv($file, $header);
        foreach ($Candidate_data as $row) {
            $array = json_decode(json_encode($row), true);
            $array['position'] = $array['position_name'];
            $array['pos_id'] = "";
            $array['position_name'] = "";
            $array['position_details'] = "";

            if (!empty($array['resume'])) {
                $array['resume'] = base_url() . substr($array['resume'], 2);
            }

            if ($array['can_type'] == 1) {
                $array['can_type'] = 'Intern';
            } else {
                $array['can_type'] = 'Regular';

            }
            if ($array['status'] == 1) {
                $array['status'] = 'Shortlisted';
            } elseif ($array['status'] == 2) {
                $array['status'] = 'On Hold';
            } else {
                $array['status'] = 'Rejected';
            }
            fputcsv($file, $array);
        }
        fclose($file);
        exit;

    }


    public function caninfo_create()
    {

        $data['title'] = display('write_y_p_info');
        #-------------------------------#
        $this->form_validation->set_rules('firstname', display('first_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('last_name', display('last_name'), 'max_length[100]');
//        $this->form_validation->set_rules('email', display('email'), 'max_length[32]|is_unique[candidate_basic_info.email]');
//        $this->form_validation->set_rules('phone', display('phone'), 'max_length[100]');
        $this->form_validation->set_rules('alter_phone', display('alter_phone'), 'max_length[100]');
        $this->form_validation->set_rules('present_address', display('present_address'), 'max_length[100]');
        $this->form_validation->set_rules('parmanent_address', display('parmanent_address'), 'max_length[100]');
        $this->load->library('myupload');
        $img = $this->myupload->do_upload(
            './application/modules/recruitment/assets/images/', 'picture'

        );
        $resume = $this->myupload->do_upload(
            './application/modules/recruitment/assets/resume/', 'resume'

        );
        $this->form_validation->set_rules('can_id', display('can_id'));
        $this->form_validation->set_rules('degree_name[]', display('degree_name'));
        $this->form_validation->set_rules('university_name[]', display('university_name'));
        $this->form_validation->set_rules('cgp[]', display('cgp'));
        $this->form_validation->set_rules('comments', display('comments'));
        $unis = $this->input->post('university_name', true);
        $degs = $this->input->post('degree_name', true);
        $cgps = $this->input->post('cgp', true);
        $year_of_completion = $this->input->post('year_of_completion', true);
        $this->form_validation->set_rules('company_name[]', display('company_name'));
        $this->form_validation->set_rules('working_period[]', display('working_period'));
        $this->form_validation->set_rules('duties[]', display('duties'));
        $this->form_validation->set_rules('supervisor[]', display('supervisor'));
        $comname = $this->input->post('company_name', true);
        $wperiod = $this->input->post('working_period', true);
        $duties = $this->input->post('duties', true);
        $past_position = $this->input->post('past_position', true);
        $supe = $this->input->post('supervisor', true);
        $id = $this->generate->id();
        $status = $this->input->post('status', true);
        #-------------------------------#
        if ($this->form_validation->run() === true) {


            $postData1 = [
                'can_id' => $id,
                'firstname' => $this->input->post('firstname', true),
                'lastname' => $this->input->post('lastname', true),
                'email' => $this->input->post('email', true),
                'phone' => $this->input->post('phone', true),
                'alter_phone' => $this->input->post('alter_phone', true),
                'present_address' => $this->input->post('present_address', true),
                'parmanent_address' => $this->input->post('parmanent_address', true),
                'picture' => $img,
                'resume' => $resume,
                'ssn' => $this->input->post('ssn', true),
                'can_type' => $this->input->post('can_type', true),
                'position' => $this->input->post('position', true),
                'state' => $this->input->post('state', true),
                'city' => $this->input->post('city', true),
                'zip' => $this->input->post('zip_code', true),
                'linkedin_profile' => $this->input->post('linkedin_profile', true),
                'github' => $this->input->post('github', true),
                'heard_about_job' => $this->input->post('heard_about_job', true),
                'english_fluency' => $this->input->post('english_fluency', true),
                'status' => $this->input->post('status', true),
            ];

            $this->db->insert('candidate_basic_info', $postData1);

            if ($status == 1) {
                $statusData = [
                    'can_id' => $id,
                    'job_adv_id' => $this->input->post('position', true),
                    'date_of_shortlist' => date("Y-m-d"),
                    'interview_date' => '',
                    'shortlisted_by' => $this->input->post('shortlisted_by', true),
                ];
                $this->db->insert('candidate_shortlist', $statusData);
            }


            for ($i = 0; $i < sizeof($unis); $i++) {
                $postData2 = [
                    'can_id' => $id,
                    'university_name' => $unis[$i],
                    'degree_name' => $degs[$i],
                    'cgp' => $cgps[$i],
                    'year_of_completion' => $year_of_completion[$i],
                    'comments' => $this->input->post('comments', true),

                ];
                if (!empty($unis[$i])) {
                    $this->Candidate_model->caneduinfo_create($postData2);
                }
            }

            for ($i = 0; $i < sizeof($comname); $i++) {
                $postData = [
                    'can_id' => $id,
                    'company_name' => $comname[$i],
                    'working_period' => $wperiod[$i],
                    'duties' => $duties[$i],
                    'past_position' => $past_position[$i],
                    'supervisor' => $supe[$i],
                ];

                if (!empty($comname[$i])) {
                    $this->Candidate_model->canworkexp_create($postData);
                }
            }

            $this->session->set_flashdata('message', display('successfully_saved'));

            redirect("recruitment/Candidate/candidateinfo_view");


        } else {
            $data['title'] = display('create_details');
            $data['module'] = "recruitment";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            $data['dropdown'] = $this->Candidate_model->dropdown();
            $data['page'] = "canInfo_form";
            $data['country_list'] = array(

                "Afghanistan" => "Afghanistan",
                "Albania" => "Albania",
                "Algeria" => "Algeria",
                "Andorra" => "Andorra",
                "Angola" => "Angola",
                "Antigua and Barbuda" => "Antigua and Barbuda",
                "Argentina" => "Argentina",
                "Armenia" => "Armenia",
                "Australia" => "Australia",
                "Austria" => "Austria",
                "Azerbaijan" => "Azerbaijan",
                "Bahamas" => "Bahamas",
                "Bahrain" => "Bahrain",
                "Bangladesh" => "Bangladesh",
                "Barbados" => "Barbados",
                "Belarus" => "Belarus",
                "Belgium" => "Belgium",
                "Belize" => "Belize",
                "Benin" => "Benin",
                "Bhutan" => "Bhutan",
                "Bolivia" => "Bolivia",
                "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
                "Botswana" => "Botswana",
                "Brazil" => "Brazil",
                "Brunei" => "Brunei",
                "Bulgaria" => "Bulgaria",
                "Burkina Faso" => "Burkina Faso",
                "Burundi" => "Burundi",
                "Cambodia" => "Cambodia",
                "Cameroon" => "Cameroon",
                "Canada" => "Canada",
                "Cape Verde" => "Cape Verde",
                "Central African Republic" => "Central African Republic",
                "Chad" => "Chad",
                "Chile" => "Chile",
                "China" => "China",
                "Colombi" => "Colombi",
                "Comoros" => "Comoros",
                "Congo (Brazzaville)" => "Congo (Brazzaville)",
                "Congo" => "Congo",
                "Costa Rica" => "Costa Rica",
                "Cote d'Ivoire" => "Cote d'Ivoire",
                "Croatia" => "Croatia",
                "Cuba" => "Cuba",
                "Cyprus" => "Cyprus",
                "Czech Republic" => "Czech Republic",
                "Denmark" => "Denmark",
                "Djibouti" => "Djibouti",
                "Dominica" => "Dominica",
                "Dominican Republic" => "Dominican Republic",
                "East Timor (Timor Timur)" => "East Timor (Timor Timur)",
                "Ecuador" => "Ecuador",
                "Egypt" => "Egypt",
                "El Salvador" => "El Salvador",
                "Equatorial Guinea" => "Equatorial Guinea",
                "Eritrea" => "Eritrea",
                "Estonia" => "Estonia",
                "Ethiopia" => "Ethiopia",
                "Fiji" => "Fiji",
                "Finland" => "Finland",
                "France" => "France",
                "Gabon" => "Gabon",
                "Gambia, The" => "Gambia, The",
                "Georgia" => "Georgia",
                "Germany" => "Germany",
                "Ghana" => "Ghana",
                "Greece" => "Greece",
                "Grenada" => "Grenada",
                "Guatemala" => "Guatemala",
                "Guinea" => "Guinea",
                "Guinea-Bissau" => "Guinea-Bissau",
                "Guyana" => "Guyana",
                "Haiti" => "Haiti",
                "Honduras" => "Honduras",
                "Hungary" => "Hungary",
                "Iceland" => "Iceland",
                "India" => "India",
                "Indonesia" => "Indonesia",
                "Iran" => "Iran",
                "Iraq" => "Iraq",
                "Ireland" => "Ireland",
                "Israel" => "Israel",
                "Italy" => "Italy",
                "Jamaica" => "Jamaica",
                "Japan" => "Japan",
                "Jordan" => "Jordan",
                "Kazakhstan" => "Kazakhstan",
                "Kenya" => "Kenya",
                "Kiribati" => "Kiribati",
                "Korea, North" => "Korea, North",
                "Korea, South" => "Korea, South",
                "Kuwait" => "Kuwait",
                "Kyrgyzstan" => "Kyrgyzstan",
                "Laos" => "Laos",
                "Latvia" => "Latvia",
                "Lebanon" => "Lebanon",
                "Lesotho" => "Lesotho",
                "Liberia" => "Liberia",
                "Libya" => "Libya",
                "Liechtenstein" => "Liechtenstein",
                "Lithuania" => "Lithuania",
                "Luxembourg" => "Luxembourg",
                "Macedonia" => "Macedonia",
                "Madagascar" => "Madagascar",
                "Malawi" => "Malawi",
                "Malaysia" => "Malaysia",
                "Maldives" => "Maldives",
                "Mali" => "Mali",
                "Malta" => "Malta",
                "Marshall Islands" => "Marshall Islands",
                "Mauritania" => "Mauritania",
                "Mauritius" => "Mauritius",
                "Mexico" => "Mexico",
                "Micronesia" => "Micronesia",
                "Moldova" => "Moldova",
                "Monaco" => "Monaco",
                "Mongolia" => "Mongolia",
                "Morocco" => "Morocco",
                "Mozambique" => "Mozambique",
                "Myanmar" => "Myanmar",
                "Namibia" => "Namibia",
                "Nauru" => "Nauru",
                "Nepal" => "Nepal",
                "Netherlands" => "Netherlands",
                "New Zealand" => "New Zealand",
                "Nicaragua" => "Nicaragua",
                "Niger" => "Niger",
                "Nigeria" => "Nigeria",
                "Norway" => "Norway",
                "Oman" => "Oman",
                "Pakistan" => "Pakistan",
                "Palau" => "Palau",
                "Panama" => "Panama",
                "Papua New Guinea" => "Papua New Guinea",
                "Paraguay" => "Paraguay",
                "Peru" => "Peru",
                "Philippines" => "Philippines",
                "Poland" => "Poland",
                "Portugal" => "Portugal",
                "Qatar" => "Qatar",
                "Romania" => "Romania",
                "Russia" => "Russia",
                "Rwanda" => "Rwanda",
                "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
                "Saint Lucia" => "Saint Lucia",
                "Saint Vincent" => "Saint Vincent",
                "Samoa" => "Samoa",
                "San Marino" => "San Marino",
                "Sao Tome and Principe" => "Sao Tome and Principe",
                "Saudi Arabia" => "Saudi Arabia",
                "Senegal" => "Senegal",
                "Serbia and Montenegro" => "Serbia and Montenegro",
                "Seychelles" => "Seychelles",
                "Sierra Leone" => "Sierra Leone",
                "Singapore" => "Singapore",
                "Slovakia" => "Slovakia",
                "Slovenia" => "Slovenia",
                "Solomon Islands" => "Solomon Islands",
                "Somalia" => "Somalia",
                "South Africa" => "South Africa",
                "Spain" => "Spain",
                "Sri Lanka" => "Sri Lanka",
                "Sudan" => "Sudan",
                "Suriname" => "Suriname",
                "Swaziland" => "Swaziland",
                "Sweden" => "Sweden",
                "Switzerland" => "Switzerland",
                "Syria" => "Syria",
                "Taiwan" => "Taiwan",
                "Tajikistan" => "Tajikistan",
                "Tanzania" => "Tanzania",
                "Thailand" => "Thailand",
                "Togo" => "Togo",
                "Tonga" => "Tonga",
                "Trinidad and Tobago" => "Trinidad and Tobago",
                "Tunisia" => "Tunisia",
                "Turkey" => "Turkey",
                "Turkmenistan" => "Turkmenistan",
                "Tuvalu" => "Tuvalu",
                "Uganda" => "Uganda",
                "Ukraine" => "Ukraine",
                "United Arab Emirates" => "United Arab Emirates",
                "United Kingdom" => "United Kingdom",
                "United States" => "United States",
                "Uruguay" => "Uruguay",
                "Uzbekistan" => "Uzbekistan",
                "Vanuatu" => "Vanuatu",
                "Vatican City" => "Vatican City",
                "Venezuela" => "Venezuela",
                "Vietnam" => "Vietnam",
                "Yemen" => "Yemen",
                "Zambia" => "Zambia",
                "Zimbabwe" => "Zimbabwe"
            );
            echo Modules::run('template/layout', $data);

        }
    }
    /*  ########################    details save  #######################################  */

    /* ############# For viewing details  #################### */
    public function candatails_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = display('view details');;
        $data['all_data'] = $this->Candidate_model->retrieve_all_data();
        $data['module'] = "recruitment";
        $data['page'] = "can_details";
        echo Modules::run('template/layout', $data);
    }

    public function cv()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = display('view details');
        $id = $this->uri->segment(4);
        $data['cv'] = $this->Candidate_model->employee_details($id);
        $data['edu'] = $this->Candidate_model->eduInfo($id);
        $data['wrk'] = $this->Candidate_model->workingexp($id);
        $data['module'] = "recruitment";
        $data['page'] = "cv";
        echo Modules::run('template/layout', $data);
    }

    /* ############# For viewing details  #################### */


    public function delete_canInfo($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();

        if ($this->Candidate_model->delete_cinfo($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate/candidateinfo_view');
    }

    public function update_canifo_form($id = null)
    {

        $data['title'] = display('write_y_p_info');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', null, 'required|max_length[20]');
        $this->form_validation->set_rules('firstname', display('first_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('lastname', display('last_name'), 'max_length[100]');
        $this->form_validation->set_rules('email', display('email'), 'max_length[32]');
        $this->form_validation->set_rules('phone', display('phone'), 'max_length[100]');
        $this->form_validation->set_rules('alter_phone', display('alter_phone'), 'max_length[100]');
        $this->form_validation->set_rules('present_address', display('present_address'), 'max_length[100]');
        $this->form_validation->set_rules('parmanent_address', display('parmanent_address'), 'max_length[100]');
        $this->load->library('myupload');
        $img = $this->myupload->do_upload(
            './application/modules/recruitment/assets/images/', 'picture'

        );

        $this->form_validation->set_rules('degree_name[]', display('degree_name'));
        $this->form_validation->set_rules('university_name[]', display('university_name'));
        $this->form_validation->set_rules('cgp[]', display('cgp'));
        $this->form_validation->set_rules('comments', display('comments'));
        $unis = $this->input->post('university_name', true);
        $degs = $this->input->post('degree_name', true);
        $cgps = $this->input->post('cgp', true);
        $year_of_completion = $this->input->post('year_of_completion', true);
        $this->form_validation->set_rules('company_name[]', display('company_name'));
        $this->form_validation->set_rules('working_period[]', display('working_period'));
        $this->form_validation->set_rules('duties[]', display('duties'));
        $this->form_validation->set_rules('supervisor[]', display('supervisor'));
        $comname = $this->input->post('company_name', true);
        $wperiod = $this->input->post('working_period', true);
        $duties = $this->input->post('duties', true);
        $past_position = $this->input->post('past_position', true);
        $supe = $this->input->post('supervisor', true);

        $status = $this->input->post('status', true);

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData1 = [
                'can_id' => $this->input->post('can_id', true),
                'firstname' => $this->input->post('firstname', true),
                'lastname' => $this->input->post('lastname', true),
                'email' => $this->input->post('email', true),
                'phone' => $this->input->post('phone', true),
                'alter_phone' => $this->input->post('alter_phone', true),
                'present_address' => $this->input->post('present_address', true),
                'parmanent_address' => $this->input->post('parmanent_address', true),
                'picture' => (!empty($img) ? $img : $this->input->post('picture')),
                'ssn' => $this->input->post('ssn', true),
                'can_type' => $this->input->post('can_type', true),
                'position' => $this->input->post('position', true),
                'state' => $this->input->post('state', true),
                'city' => $this->input->post('city', true),
                'zip' => $this->input->post('zip_code', true),
                'linkedin_profile' => $this->input->post('linkedin_profile', true),
                'github' => $this->input->post('github', true),
                'heard_about_job' => $this->input->post('heard_about_job', true),
                'english_fluency' => $this->input->post('english_fluency', true),
                'status' => $this->input->post('status', true),
            ];

            $this->Candidate_model->update_canInfo($postData1);

            if ($status == 1) {
                $this->db->where('can_id', $this->input->post('can_id', true))
                    ->delete('candidate_shortlist');
                $statusData = [
                    'can_id' => $this->input->post('can_id', true),
                    'job_adv_id' => $this->input->post('position', true),
                    'date_of_shortlist' => date("Y-m-d"),
                    'interview_date' => '',
                    'shortlisted_by' => $this->input->post('shortlisted_by', true),
                ];
                $this->db->insert('candidate_shortlist', $statusData);
            } elseif ($status == 2) {
                $this->db->where('can_id', $this->input->post('can_id', true))
                    ->delete('candidate_shortlist');
            }

            $this->db->where('can_id', $this->input->post('can_id', true))
                ->delete('candidate_education_info');
            for ($i = 0; $i < sizeof($unis); $i++) {
                $postData2 = [
                    'can_id' => $this->input->post('can_id', true),
                    'university_name' => $unis[$i],
                    'degree_name' => $degs[$i],
                    'cgp' => $cgps[$i],
                    'year_of_completion' => $year_of_completion[$i],
                    'comments' => $this->input->post('comments', true),

                ];
                if (!empty($unis[$i])) {
                    $this->db->insert('candidate_education_info', $postData2);
                }
            }

            $this->db->where('can_id', $this->input->post('can_id', true))
                ->delete('candidate_workexperience');

            for ($i = 0; $i < sizeof($comname); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id', true),
                    'company_name' => $comname[$i],
                    'working_period' => $wperiod[$i],
                    'duties' => $duties[$i],
                    'past_position' => $past_position[$i],
                    'supervisor' => $supe[$i],

                ];

                if (!empty($comname[$i])) {
                    $this->db->insert('candidate_workexperience', $postData);
                }
            }

            $this->session->set_flashdata('message', display('successfully_updated'));

            redirect("recruitment/Candidate/candidateinfo_view");


        } else {
            $id = $this->uri->segment(4);
            $data['title'] = display('create_details');
            $data['module'] = "recruitment";
            $data['basinfo'] = $this->Candidate_model->canifo_updateForm($id);
            $data['edinfo'] = $this->Candidate_model->canEdu_updateForm($id);
            $data['work'] = $this->Candidate_model->work($id);
            $data['edu'] = $this->Candidate_model->upcanedu($id);
            $data['dropdown'] = $this->Candidate_model->dropdown();
            $data['page'] = "update_canIfo";
            $data['country_list'] = array(

                "Afghanistan" => "Afghanistan",
                "Albania" => "Albania",
                "Algeria" => "Algeria",
                "Andorra" => "Andorra",
                "Angola" => "Angola",
                "Antigua and Barbuda" => "Antigua and Barbuda",
                "Argentina" => "Argentina",
                "Armenia" => "Armenia",
                "Australia" => "Australia",
                "Austria" => "Austria",
                "Azerbaijan" => "Azerbaijan",
                "Bahamas" => "Bahamas",
                "Bahrain" => "Bahrain",
                "Bangladesh" => "Bangladesh",
                "Barbados" => "Barbados",
                "Belarus" => "Belarus",
                "Belgium" => "Belgium",
                "Belize" => "Belize",
                "Benin" => "Benin",
                "Bhutan" => "Bhutan",
                "Bolivia" => "Bolivia",
                "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
                "Botswana" => "Botswana",
                "Brazil" => "Brazil",
                "Brunei" => "Brunei",
                "Bulgaria" => "Bulgaria",
                "Burkina Faso" => "Burkina Faso",
                "Burundi" => "Burundi",
                "Cambodia" => "Cambodia",
                "Cameroon" => "Cameroon",
                "Canada" => "Canada",
                "Cape Verde" => "Cape Verde",
                "Central African Republic" => "Central African Republic",
                "Chad" => "Chad",
                "Chile" => "Chile",
                "China" => "China",
                "Colombi" => "Colombi",
                "Comoros" => "Comoros",
                "Congo (Brazzaville)" => "Congo (Brazzaville)",
                "Congo" => "Congo",
                "Costa Rica" => "Costa Rica",
                "Cote d'Ivoire" => "Cote d'Ivoire",
                "Croatia" => "Croatia",
                "Cuba" => "Cuba",
                "Cyprus" => "Cyprus",
                "Czech Republic" => "Czech Republic",
                "Denmark" => "Denmark",
                "Djibouti" => "Djibouti",
                "Dominica" => "Dominica",
                "Dominican Republic" => "Dominican Republic",
                "East Timor (Timor Timur)" => "East Timor (Timor Timur)",
                "Ecuador" => "Ecuador",
                "Egypt" => "Egypt",
                "El Salvador" => "El Salvador",
                "Equatorial Guinea" => "Equatorial Guinea",
                "Eritrea" => "Eritrea",
                "Estonia" => "Estonia",
                "Ethiopia" => "Ethiopia",
                "Fiji" => "Fiji",
                "Finland" => "Finland",
                "France" => "France",
                "Gabon" => "Gabon",
                "Gambia, The" => "Gambia, The",
                "Georgia" => "Georgia",
                "Germany" => "Germany",
                "Ghana" => "Ghana",
                "Greece" => "Greece",
                "Grenada" => "Grenada",
                "Guatemala" => "Guatemala",
                "Guinea" => "Guinea",
                "Guinea-Bissau" => "Guinea-Bissau",
                "Guyana" => "Guyana",
                "Haiti" => "Haiti",
                "Honduras" => "Honduras",
                "Hungary" => "Hungary",
                "Iceland" => "Iceland",
                "India" => "India",
                "Indonesia" => "Indonesia",
                "Iran" => "Iran",
                "Iraq" => "Iraq",
                "Ireland" => "Ireland",
                "Israel" => "Israel",
                "Italy" => "Italy",
                "Jamaica" => "Jamaica",
                "Japan" => "Japan",
                "Jordan" => "Jordan",
                "Kazakhstan" => "Kazakhstan",
                "Kenya" => "Kenya",
                "Kiribati" => "Kiribati",
                "Korea, North" => "Korea, North",
                "Korea, South" => "Korea, South",
                "Kuwait" => "Kuwait",
                "Kyrgyzstan" => "Kyrgyzstan",
                "Laos" => "Laos",
                "Latvia" => "Latvia",
                "Lebanon" => "Lebanon",
                "Lesotho" => "Lesotho",
                "Liberia" => "Liberia",
                "Libya" => "Libya",
                "Liechtenstein" => "Liechtenstein",
                "Lithuania" => "Lithuania",
                "Luxembourg" => "Luxembourg",
                "Macedonia" => "Macedonia",
                "Madagascar" => "Madagascar",
                "Malawi" => "Malawi",
                "Malaysia" => "Malaysia",
                "Maldives" => "Maldives",
                "Mali" => "Mali",
                "Malta" => "Malta",
                "Marshall Islands" => "Marshall Islands",
                "Mauritania" => "Mauritania",
                "Mauritius" => "Mauritius",
                "Mexico" => "Mexico",
                "Micronesia" => "Micronesia",
                "Moldova" => "Moldova",
                "Monaco" => "Monaco",
                "Mongolia" => "Mongolia",
                "Morocco" => "Morocco",
                "Mozambique" => "Mozambique",
                "Myanmar" => "Myanmar",
                "Namibia" => "Namibia",
                "Nauru" => "Nauru",
                "Nepal" => "Nepal",
                "Netherlands" => "Netherlands",
                "New Zealand" => "New Zealand",
                "Nicaragua" => "Nicaragua",
                "Niger" => "Niger",
                "Nigeria" => "Nigeria",
                "Norway" => "Norway",
                "Oman" => "Oman",
                "Pakistan" => "Pakistan",
                "Palau" => "Palau",
                "Panama" => "Panama",
                "Papua New Guinea" => "Papua New Guinea",
                "Paraguay" => "Paraguay",
                "Peru" => "Peru",
                "Philippines" => "Philippines",
                "Poland" => "Poland",
                "Portugal" => "Portugal",
                "Qatar" => "Qatar",
                "Romania" => "Romania",
                "Russia" => "Russia",
                "Rwanda" => "Rwanda",
                "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
                "Saint Lucia" => "Saint Lucia",
                "Saint Vincent" => "Saint Vincent",
                "Samoa" => "Samoa",
                "San Marino" => "San Marino",
                "Sao Tome and Principe" => "Sao Tome and Principe",
                "Saudi Arabia" => "Saudi Arabia",
                "Senegal" => "Senegal",
                "Serbia and Montenegro" => "Serbia and Montenegro",
                "Seychelles" => "Seychelles",
                "Sierra Leone" => "Sierra Leone",
                "Singapore" => "Singapore",
                "Slovakia" => "Slovakia",
                "Slovenia" => "Slovenia",
                "Solomon Islands" => "Solomon Islands",
                "Somalia" => "Somalia",
                "South Africa" => "South Africa",
                "Spain" => "Spain",
                "Sri Lanka" => "Sri Lanka",
                "Sudan" => "Sudan",
                "Suriname" => "Suriname",
                "Swaziland" => "Swaziland",
                "Sweden" => "Sweden",
                "Switzerland" => "Switzerland",
                "Syria" => "Syria",
                "Taiwan" => "Taiwan",
                "Tajikistan" => "Tajikistan",
                "Tanzania" => "Tanzania",
                "Thailand" => "Thailand",
                "Togo" => "Togo",
                "Tonga" => "Tonga",
                "Trinidad and Tobago" => "Trinidad and Tobago",
                "Tunisia" => "Tunisia",
                "Turkey" => "Turkey",
                "Turkmenistan" => "Turkmenistan",
                "Tuvalu" => "Tuvalu",
                "Uganda" => "Uganda",
                "Ukraine" => "Ukraine",
                "United Arab Emirates" => "United Arab Emirates",
                "United Kingdom" => "United Kingdom",
                "United States" => "United States",
                "Uruguay" => "Uruguay",
                "Uzbekistan" => "Uzbekistan",
                "Vanuatu" => "Vanuatu",
                "Vatican City" => "Vatican City",
                "Venezuela" => "Venezuela",
                "Vietnam" => "Vietnam",
                "Yemen" => "Yemen",
                "Zambia" => "Zambia",
                "Zimbabwe" => "Zimbabwe"
            );
            echo Modules::run('template/layout', $data);

        }
    }

    /*##################### ---Advertisement part---####################*/


    public function candidate_edu_info_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = display('educationinfo_list');;
        $data['edu'] = $this->Candidate_model->viewEduinfo();
        $data['module'] = "recruitment";
        $data['page'] = "canInfoview";
        echo Modules::run('template/layout', $data);
    }

    public function create_can_eduinfo()
    {
        /***** file upload code start ***********/

        $data['title'] = display('educationinfo_list');

        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'));
        $this->form_validation->set_rules('degree_name[]', display('degree_name'));
        $this->form_validation->set_rules('university_name[]', display('university_name'));
        $this->form_validation->set_rules('cgp[]', display('cgp'));
        $this->form_validation->set_rules('comments', display('comments'), 'required');
        $unis = $this->input->post('university_name', true);
        $degs = $this->input->post('degree_name', true);
        $cgps = $this->input->post('cgp', true);

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $id = $this->input->post('can_id', true);

            for ($i = 0; $i < sizeof($unis); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id', true),
                    'university_name' => $unis[$i],
                    'degree_name' => $degs[$i],
                    'cgp' => $cgps[$i],
                    'comments' => $this->input->post('comments', true),

                ];
                $this->Candidate_model->caneduinfo_create($postData);
            }

            $this->session->set_flashdata('message', display('save_successfully'));
            redirect("recruitment/Candidate/caninfo_create/$id/#tabs-3");


        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "can_edu_form";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            echo Modules::run('template/layout', $data);

        }
    }

    public function delete_can_edu_Info($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();

        if ($this->Candidate_model->delete_canedu_info($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate/candidateinfo_view');
    }


    public function update_can_eduifo_form($id = null)
    {
        $this->form_validation->set_rules('can_id', display('can_id'));
        $this->form_validation->set_rules('degree_name[]', display('degree_name'));
        $this->form_validation->set_rules('university_name[]', display('university_name'));
        $this->form_validation->set_rules('cgp[]', display('cgp'));
        $this->form_validation->set_rules('comments', display('comments'), 'required');
        $unis = $this->input->post('university_name', true);
        $degs = $this->input->post('degree_name', true);
        $cgps = $this->input->post('cgp', true);

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $this->db->where('can_id', $this->input->post('can_id', true))
                ->delete('candidate_education_info');


            for ($i = 0; $i < sizeof($unis); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id', true),
                    'university_name' => $unis[$i],
                    'degree_name' => $degs[$i],
                    'cgp' => $cgps[$i],
                    'comments' => $this->input->post('comments', true),

                ];


                $this->db->insert('candidate_education_info', $postData);
            }

            $this->session->set_flashdata('message', display('successfully_updated'));


            redirect("recruitment/Candidate/candidateinfo_view/" . $id);

        } else {
            $data['title'] = display('update');
            $id = $this->uri->segment(4);
            $data['data'] = $this->Candidate_model->canEdu_updateForm($id);
            $data['edu'] = $this->Candidate_model->upcanedu($id);
            $data['work'] = $this->Candidate_model->work($id);
            $data['query'] = $this->Candidate_model->get_eduinf_dropdown($id);
            $data['module'] = "recruitment";

            $data['page'] = "update_canedu_form";
            echo Modules::run('template/layout', $data);
        }

    }

    /***** workexperience start ***********/


    public function workexperience_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = display('educationinfo_list');;
        $data['exp'] = $this->Candidate_model->viewExperience();
        $data['module'] = "recruitment";
        $data['page'] = "workexperienceView";
        echo Modules::run('template/layout', $data);
    }

    public function create_workexperience()
    {

        $data['title'] = display('workexperience_list');

        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'), 'required');
        $this->form_validation->set_rules('company_name[]', display('company_name'));
        $this->form_validation->set_rules('working_period[]', display('working_period'));
        $this->form_validation->set_rules('duties[]', display('duties'));
        $this->form_validation->set_rules('supervisor[]', display('supervisor'));
        $comname = $this->input->post('company_name', true);
        $wperiod = $this->input->post('working_period', true);
        $duties = $this->input->post('duties', true);
        $supe = $this->input->post('supervisor', true);


        #-------------------------------#
        if ($this->form_validation->run() === true) {
            for ($i = 0; $i < sizeof($comname); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id', true),
                    'company_name' => $comname[$i],
                    'working_period' => $wperiod[$i],
                    'duties' => $duties[$i],
                    'supervisor' => $supe[$i],

                ];


                $this->Candidate_model->canworkexp_create($postData);
            }

            $this->session->set_flashdata('message', display('save_successfully'));
            redirect("recruitment/Candidate/candidateinfo_view");


        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "can_workexperience_form";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            echo Modules::run('template/layout', $data);

        }
    }

    public function update_workexperience_form($id = null)
    {
        $this->form_validation->set_rules('can_id', display('can_id'), 'required');
        $this->form_validation->set_rules('company_name[]', display('company_name'));
        $this->form_validation->set_rules('working_period[]', display('working_period'));
        $this->form_validation->set_rules('duties[]', display('duties'));
        $this->form_validation->set_rules('supervisor[]', display('supervisor'));
        $comname = $this->input->post('company_name', true);
        $wperiod = $this->input->post('working_period', true);
        $duties = $this->input->post('duties', true);
        $supe = $this->input->post('supervisor', true);


        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $this->db->where('can_id', $this->input->post('can_id', true))
                ->delete('candidate_workexperience');


            for ($i = 0; $i < sizeof($comname); $i++) {
                $postData = [
                    'can_id' => $this->input->post('can_id', true),
                    'company_name' => $comname[$i],
                    'working_period' => $wperiod[$i],
                    'duties' => $duties[$i],
                    'supervisor' => $supe[$i],

                ];


                $this->db->insert('candidate_workexperience', $postData);
            }

            $this->session->set_flashdata('message', display('successfully_updated'));


            redirect("recruitment/Candidate/candidateinfo_view/" . $id);

        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Candidate_model->workexperience_updateForm($id);
            $id = $this->uri->segment(4);
            $data['work'] = $this->Candidate_model->work($id);
            $data['module'] = "recruitment";

            $data['page'] = "update_workexperience_form";
            echo Modules::run('template/layout', $data);
        }

    }

    public function delete_workexperience($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();

        if ($this->Candidate_model->delete_workexp($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate/candidateinfo_view/#menu1');
    }


    public function view_details()
    {
        $data = array();
        $data['ab'] = $this->Candidate_model->employee_details($id);
        $this->load->view('cv', $data);


    }

    public function add_recruitment_status()
    {
        $this->form_validation->set_rules('status', "Status", 'required');

        if ($this->form_validation->run() === true) {

            $status = $this->input->post('status', true);
            $manager_name = $this->input->post('manager_name', true);
            $department_id = $this->input->post('department_id', true);
            $designation = $this->input->post('designation', true);
            $num_of_positions = $this->input->post('num_of_positions', true);
            $closed_positions = $this->input->post('closed_positions', true);
            $rrd = $this->input->post('rrd', true);
            $deadline = $this->input->post('deadline', true);
            $budget = $this->input->post('budget', true);
            $qualifications = $this->input->post('qualifications', true);
            $exp_required = $this->input->post('exp_required', true);
            $employee_type = $this->input->post('employee_type', true);
            $responsible_person = $this->input->post('responsible_person', true);
            $close_date = $this->input->post('close_date', true);
            $candidate_finalized = $this->input->post('candidate_finalized', true);
            $extra_comment = $this->input->post('extra_comment', true);

            $postData = [
                'status' => $status,
                'manager_name' => $manager_name,
                'department_id' => $department_id,
                'designation' => $designation,
                'num_of_positions' => $num_of_positions,
                'closed_positions' => $closed_positions,
                'rrd' => $rrd,
                'deadline' => $deadline,
                'budget' => $budget,
                'qualifications' => $qualifications,
                'exp_required' => $exp_required,
                'employee_type' => $employee_type,
                'responsible_person' => $responsible_person,
                'close_date' => $close_date,
                'candidate_finalized' => $candidate_finalized,
                'extra_comment' => $extra_comment,
            ];

            if ($this->Candidate_model->create_status($postData)) {
                $this->session->set_flashdata('message', display('save_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate/manage_recruitment_status");

        } else {

            $this->permission->module('recruitment', 'read')->redirect();
            $data['title'] = "Add Status";;
            $data['module'] = "recruitment";
            $data['emplist'] = $this->Candidate_model->emp_list_dropdown();
            $data['position'] = $this->Candidate_model->dropdownPos();
            $data['department'] = $this->Candidate_model->dropdowndept();
            $data['page'] = "add_recruitment_status";
            echo Modules::run('template/layout', $data);
        }

    }

    public function manage_recruitment_status()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = "Status List";;
        $data['module'] = "recruitment";
        $data['activeStatus'] = $this->Candidate_model->get_active_status();
        $data['holdStatus'] = $this->Candidate_model->get_hold_status();
        $data['closedStatus'] = $this->Candidate_model->get_closed_status();
        $data['page'] = "manage_recruitment_status";
        echo Modules::run('template/layout', $data);
    }

    public function update_recruitment_status($id = null)
    {

        $this->form_validation->set_rules('status', "Status", 'required');

        if ($this->form_validation->run() === true) {
            $status_id = $this->input->post('status_id', true);
            $status = $this->input->post('status', true);
            $manager_name = $this->input->post('manager_name', true);
            $department_id = $this->input->post('department_id', true);
            $designation = $this->input->post('designation', true);
            $num_of_positions = $this->input->post('num_of_positions', true);
            $closed_positions = $this->input->post('closed_positions', true);
            $rrd = $this->input->post('rrd', true);
            $deadline = $this->input->post('deadline', true);
            $budget = $this->input->post('budget', true);
            $qualifications = $this->input->post('qualifications', true);
            $exp_required = $this->input->post('exp_required', true);
            $employee_type = $this->input->post('employee_type', true);
            $responsible_person = $this->input->post('responsible_person', true);
            $close_date = $this->input->post('close_date', true);
            $candidate_finalized = $this->input->post('candidate_finalized', true);
            $extra_comment = $this->input->post('extra_comment', true);

            $postData = [
                'status_id' => $status_id,
                'status' => $status,
                'manager_name' => $manager_name,
                'department_id' => $department_id,
                'designation' => $designation,
                'num_of_positions' => $num_of_positions,
                'closed_positions' => $closed_positions,
                'rrd' => $rrd,
                'deadline' => $deadline,
                'budget' => $budget,
                'qualifications' => $qualifications,
                'exp_required' => $exp_required,
                'employee_type' => $employee_type,
                'responsible_person' => $responsible_person,
                'close_date' => $close_date,
                'candidate_finalized' => $candidate_finalized,
                'extra_comment' => $extra_comment,
            ];

            if ($this->Candidate_model->update_status($postData)) {
                $this->session->set_flashdata('message', display('save_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate/manage_recruitment_status");
        } else {
            $data['title'] = "Update Status";;
            $data['module'] = "recruitment";
            $data['emplist'] = $this->Candidate_model->emp_list_dropdown();
            $data['position'] = $this->Candidate_model->dropdownPos();
            $data['department'] = $this->Candidate_model->dropdowndept();
            $data['getStatus'] = $this->Candidate_model->get_status($id);
            $data['page'] = "add_recruitment_status";
            echo Modules::run('template/layout', $data);
        }

    }

    public function delete_recruitment_status($id)
    {
        if ($this->Candidate_model->delete_status($id)) {
            $this->session->set_flashdata('message', "Deleted Successfully");
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("recruitment/Candidate/manage_recruitment_status");
    }


}
