<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Resignation extends MX_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Resignation_model'
        ));

        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function create_resignation()
    {
        $data['title'] = "Resignation";
        /*----------FORM VALIDATION RULES----------*/
        $this->form_validation->set_rules('res_message', display('message'), 'required|trim');
        /*-------------STORE DATA------------*/

        $this->load->library('myupload');
        $attachment = $this->myupload->do_upload(
            './application/modules/employee/assets/attachments/',
            'res_attachment'

        );

        if ($attachment == null) {
            $res_attachment = '';
        } else {
            $res_attachment = base_url() . $attachment;
        }

        $data['message'] = (object)$postData = array(
            'res_message' => $this->input->post('res_message', true),
            'res_attachment' => $res_attachment,
            'supervisor_id' => $this->input->post('supervisor_id', true),
            'employee_id' => $this->input->post('employee_id', true),
            'res_initiate_date' => $this->input->post('res_initiate_date', true),
            'notice_date' => $this->input->post('notice_date', true),
        );

        /*-----------CREATE A NEW RECORD-----------*/
        if ($this->form_validation->run() === true) {
            if ($this->Resignation_model->create_resignation($postData)) {
                #set success message
                $this->session->set_flashdata('message', "Your resignation has been sent to your supervisor");
            } else {
                #set exception message
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('resignation/Resignation/create_resignation');
        } else {
            $email = $this->session->userdata('email');
            $data['emp_details'] = $this->Resignation_model->get_employee_details($email);
            $emp_id = $data['emp_details'][0]->employee_id;
            $data['check_resignation'] = $this->Resignation_model->check_resignation($emp_id);
            $data['module'] = "resignation";
            $data['page'] = "create_resignation";
            echo Modules::run('template/layout', $data);
        }
    }

    public function resignation_requests()
    {
        $data['title'] = display('resignation_requests');

        $email = $this->session->userdata('email');
        $data['emp_details'] = $this->Resignation_model->get_employee_details($email);
        $emp_id = $data['emp_details'][0]->employee_id;
        $data['resignation_details'] = $this->Resignation_model->get_resignations_list($emp_id);
        $data['get_resignations_emp'] = $this->Resignation_model->get_resignations_emp($emp_id);
        $data['resignation_details_admin'] = $this->Resignation_model->get_resignations_list_admin($emp_id);
        $data['module'] = "resignation";
        $data['page'] = "resignation_request";
        echo Modules::run('template/layout', $data);

    }

    public function resignation_status()
    {
        $data['title'] = display('resignation_requests');

        $email = $this->session->userdata('email');
        $data['emp_details'] = $this->Resignation_model->get_employee_details($email);
        $emp_id = $data['emp_details'][0]->employee_id;
        $data['get_resignations_emp'] = $this->Resignation_model->get_resignations_emp($emp_id);
        $data['module'] = "resignation";
        $data['page'] = "resignation_status";
        echo Modules::run('template/layout', $data);

    }

    public function approve_by_supervisors()
    {
        $data['title'] = display('resignation_requests');

        $email = $this->session->userdata('email');
        $data['emp_details'] = $this->Resignation_model->get_employee_details($email);
        $emp_id = $data['emp_details'][0]->employee_id;
        $data['resignation_details'] = $this->Resignation_model->get_resignations_list($emp_id);
        $data['get_resignations_emp'] = $this->Resignation_model->get_resignations_emp($emp_id);
        $data['resignation_details_admin'] = $this->Resignation_model->get_resignations_list_admin($emp_id);
        $data['module'] = "resignation";
        $data['page'] = "approve_by_supervisors";
        echo Modules::run('template/layout', $data);

    }

    public function view_resignation_request($id = null)
    {
        $data['title'] = display('resignation_requests');
        $data['data'] = $this->Resignation_model->resignation_update_form($id);
        $data['module'] = "resignation";
        $data['page'] = "view_resignation_request";
        echo Modules::run('template/layout', $data);

    }

    public function view_resignation_request_admin($id = null)
    {
        $data['title'] = display('resignation_requests');
        $data['data'] = $this->Resignation_model->resignation_update_form($id);
        $data['module'] = "resignation";
        $data['page'] = "view_resignation_request_admin";
        echo Modules::run('template/layout', $data);

    }

    public function edit_resignation_sup()
    {

        $this->form_validation->set_rules('approve_by_supervisor', "Approval", 'required');
        $this->form_validation->set_rules('res_sup_comment', "Comments", 'required');

        $res_id = $this->input->post('res_id', true);
        $employee_id = $this->input->post('employee_id', true);
        $approve_by_supervisor = $this->input->post('approve_by_supervisor', true);
        $res_sup_comment = $this->input->post('res_sup_comment', true);
        $notice_date = $this->input->post('notice_date', true);

        $data['emp_details'] = $this->Resignation_model->get_employee_details_by_id($employee_id);

        $emp_full_name = $data['emp_details'][0]->first_name . " " . $data['emp_details'][0]->last_name;
        $emp_email = $data['emp_details'][0]->email;

        $data['approval'] = (object)$postData = array(
            'res_id' => $res_id,
            'employee_id' => $employee_id,
            'approve_by_supervisor' => $approve_by_supervisor,
            'res_sup_comment' => $res_sup_comment,
            'notice_date' => $notice_date
        );

        if ($this->form_validation->run() === true) {

            if ($this->Resignation_model->approve_resignation($postData)) {

                if ($approve_by_supervisor == 0) {
                    // the message
                    $msg = "Hi! $emp_full_name \n Sorry! your resignation request has been rejected from your supervisor";
                    $msg = wordwrap($msg, 70);

                    mail($emp_email, "Resignation Request", $msg);
                }
                #set success message
                $this->session->set_flashdata('message', "Record Updated");
            } else {
                #set exception message
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('resignation/Resignation/resignation_requests');
        } else {
            $this->session->set_flashdata('exception', validation_errors());
            redirect('resignation/Resignation/view_resignation_request/'.$res_id);
        }
    }

    public function edit_resignation_admin()
    {
        $this->form_validation->set_rules('approve_by_hr', "Approval", 'required');
        $this->form_validation->set_rules('res_hr_comment', "Comments", 'required');

        $res_id = $this->input->post('res_id', true);
        $employee_id = $this->input->post('employee_id', true);
        $approve_by_hr = $this->input->post('approve_by_hr', true);
        $res_hr_comment = $this->input->post('res_hr_comment', true);

        $data['emp_details'] = $this->Resignation_model->get_employee_details_by_id($employee_id);

        $emp_full_name = $data['emp_details'][0]->first_name . " " . $data['emp_details'][0]->last_name;
        $emp_email = $data['emp_details'][0]->email;

        $data['approval'] = (object)$postData = array(
            'res_id' => $res_id,
            'employee_id' => $employee_id,
            'approve_by_hr' => $approve_by_hr,
            'res_hr_comment' => $res_hr_comment,
        );

        if ($this->form_validation->run() === true) {

            if ($this->Resignation_model->approve_resignation($postData)) {

                if ($approve_by_hr == 0) {
                    // the message
                    $msg = "Hi! $emp_full_name \n Sorry! your resignation request has been rejected by HR";
                    $msg = wordwrap($msg, 70);

                    mail($emp_email, "Resignation Request", $msg);
                } elseif ($approve_by_hr == 1) {
                    // the message
                    $msg = "Hi! $emp_full_name \n Your resignation request has been accepted by HR";
                    $msg = wordwrap($msg, 70);

                    mail($emp_email, "Resignation Request", $msg);
                }
                #set success message
                $this->session->set_flashdata('message', "Record Updated");
            } else {
                #set exception message
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('resignation/Resignation/approve_by_supervisors');
        }
        else {
            $this->session->set_flashdata('exception', validation_errors());
            redirect('resignation/Resignation/view_resignation_request_admin/'.$res_id);
        }
    }

}