<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Resignation_model extends CI_Model
{

    public function get_employee_details($email)
    {
        $this->db->select("*");
        $this->db->from('employee_history');
        $this->db->where('email', $email);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_employee_details_by_id($id)
    {
        $this->db->select("*");
        $this->db->from('employee_history');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }

    public function create_resignation($data = [])
    {
        $this->db->insert('resignation', $data);
        return true;
    }

    public function get_resignations_list($id)
    {
        $this->db->select('resignation.* ,employee_history.*');
        $this->db->join('employee_history', 'employee_history.employee_id = resignation.employee_id');
        $this->db->where('supervisor_id', $id);
        $this->db->from('resignation');
        $this->db->order_by('supervisor_id', 'desc');
        $query = $this->db->get();
        return $query->result();

    }

    public function get_resignations_emp($id)
    {
        $this->db->select("*");
        $this->db->from('resignation');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();

    }

    public function resignation_update_form($id){
        $this->db->where('res_id', $id);
        $query = $this->db->get('resignation');
        return $query->row();
    }

    public function approve_resignation($data = array()){
        return $this->db->where('res_id', $data["res_id"])
            ->update("resignation", $data);
    }

    public function get_resignations_list_admin($id)
    {
        $this->db->select('resignation.* ,employee_history.*');
        $this->db->join('employee_history', 'employee_history.employee_id = resignation.employee_id');
        $this->db->where('approve_by_supervisor', 1);
        $this->db->from('resignation');
        $this->db->order_by('supervisor_id', 'desc');
        $query = $this->db->get();
        return $query->result();

    }

    public function check_resignation($id){
        $this->db->select("*");
        $this->db->from('resignation');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }

}