<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Training_controller extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Training_model'
        ));
        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function training_view()
    {
        $this->permission->method('training', 'read')->redirect();

        $data['title'] = display('training');;
        $data['mang'] = $this->Training_model->training_view();
        $data['module'] = "training";
        $data['page'] = "training_view";
        echo Modules::run('template/layout', $data);
    }

    public function create_training()
    {
        $this->form_validation->set_rules('course_name', 'Course Name');
        $this->form_validation->set_rules('training_date', 'Training Date');
        $this->form_validation->set_rules('session_info', 'Session Info');
        $this->form_validation->set_rules('comments', "Comments", 'max_length[500]');
        $this->form_validation->set_rules('expiration_date', "Expiration Date", 'max_length[70]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[70]');


        #-------------------------------#
        if ($this->form_validation->run() === true) {


            $postData = [
                'course_name' => $this->input->post('course_name', true),
                'training_date' => $this->input->post('training_date', true),
                'session_info' => $this->input->post('session_info', true),
                'comments' => $this->input->post('comments', true),
                'expiration_date' => $this->input->post('expiration_date', true),
                'employee_id' => $this->input->post('employee_id', true),

            ];

            if ($this->Training_model->training_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("training/Training_controller/create_training");


        } else {
            $data['title'] = display('training');
            $data['module'] = "training";
            $data['mang'] = $this->Training_model->training_view();
            $data['dropdown'] = $this->Training_model->dropdown();
            $data['page'] = "training_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function update_training_form($id = null)
    {
        $data['title'] = display('training');
        #-------------------------------#
        $this->form_validation->set_rules('course_name', 'Course Name');
        $this->form_validation->set_rules('training_date', 'Training Date');
        $this->form_validation->set_rules('session_info', 'Session Info');
        $this->form_validation->set_rules('comments', "Comments", 'max_length[500]');
        $this->form_validation->set_rules('expiration_date', "Expiration Date", 'max_length[70]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[70]');

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $Data = [
                'training_id' => $this->input->post('training_id', true),
                'course_name' => $this->input->post('course_name', true),
                'training_date' => $this->input->post('training_date', true),
                'session_info' => $this->input->post('session_info', true),
                'comments' => $this->input->post('comments', true),
                'expiration_date' => $this->input->post('expiration_date', true),
                'employee_id' => $this->input->post('employee_id', true),
            ];

            if ($this->Training_model->update_training($Data)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("training/Training_controller/training_view");


        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Training_model->training_updateForm($id);
            $data['dropdown'] = $this->Training_model->dropdown();
            $data['bb'] = $this->Training_model->get_id($id);
            $data['module'] = "training";
            $data['page'] = "update_training_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function delete_training($id = null)
    {
        $this->permission->method('training','delete')->redirect();

        if ($this->Training_model->training_delete($id)) {
            #set success message
            $this->session->set_flashdata('message',display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception',display('please_try_again'));

        }
        redirect("training/Training_controller/training_view");
    }

}
